<?php
include '../../../includes/config.php'; 
$ws = "SELECT * FROM website";
$we = mysqli_query($conn, $ws);
$w = mysqli_fetch_assoc($we);
$wname = $w['name'];
$tagline = $w['tagline'];
require('config.php');
require('razorpay-php/Razorpay.php');
session_start();

// Create the Razorpay Order
$email = $_SESSION['useremail'];
$phone = $_SESSION['userphone'];
$amount = $_POST['amount'];
$_SESSION['rzpamt'] = $amount ;
$username = $_SESSION['username'];
use Razorpay\Api\Api;

$api = new Api($keyId, $keySecret);

//
// We create an razorpay order using orders api
// Docs: https://docs.razorpay.com/docs/orders
//
$orderData = [
    'receipt'         => 3456,
    'amount'          => $amount * 100, // 2000 rupees in paise
    'currency'        => 'INR',
    'payment_capture' => 1 // auto capture
];

$razorpayOrder = $api->order->create($orderData);

$razorpayOrderId = $razorpayOrder['id'];

$_SESSION['razorpay_order_id'] = $razorpayOrderId;

$displayAmount = $amount = $orderData['amount'];

if ($displayCurrency !== 'INR')
{
    $url = "https://api.fixer.io/latest?symbols=$displayCurrency&base=INR";
    $exchange = json_decode(file_get_contents($url), true);

    $displayAmount = $exchange['rates'][$displayCurrency] * $amount / 100;
}

$checkout = 'automatic';

if (isset($_GET['checkout']) and in_array($_GET['checkout'], ['automatic', 'manual'], true))
{
    $checkout = $_GET['checkout'];
}

$data = [
    "key"               => $keyId,
    "amount"            => $amount,
    "name"              => $wname,
    "description"       => $tagline,
    "image"             => "https://s29.postimg.org/r6dj1g85z/daft_punk.jpg",
    "prefill"           => [
    "name"              => $username,
    "email"             => $email,
    "contact"           => $phone,
    ],
    "notes"             => [
    "address"           => "",
    "merchant_order_id" => "12312321",
    ],
    "theme"             => [
    "color"             => "#F37254"
    ],
    "order_id"          => $razorpayOrderId,
];

if ($displayCurrency !== 'INR')
{
    $data['display_currency']  = $displayCurrency;
    $data['display_amount']    = $displayAmount;
}

$json = json_encode($data);

require("checkout/{$checkout}.php");
?>
<script>

window.onload = function(){
  document.getElementById('rzp-button1').click();
}
</script>